/*
 * Decompiled with CFR 0.152.
 */
package element;

import element.Drawable;
import element.DrawingWindow;
import element.Pt;
import element.Rect;

public class Line
implements Drawable {
    private int x0;
    private int y0;
    private int x1;
    private int y1;

    public Line() {
        this(0, 0, 0, 0);
    }

    public Line(int n, int n2, int n3, int n4) {
        if (n < n3 || n == n3 && n2 <= n4) {
            this.x0 = n;
            this.x1 = n3;
            this.y0 = n2;
            this.y1 = n4;
        } else {
            this.x0 = n3;
            this.x1 = n;
            this.y0 = n4;
            this.y1 = n2;
        }
    }

    public Line(Line line) {
        this.x0 = line.x0;
        this.x1 = line.x1;
        this.y0 = line.y0;
        this.y1 = line.y1;
    }

    public Line(Pt pt, Pt pt2) {
        this(pt.x(), pt.y(), pt2.x(), pt2.y());
    }

    public Line(Rect rect) {
        this.x0 = rect.left();
        this.x1 = rect.right();
        this.y0 = rect.top();
        this.y1 = rect.bottom();
    }

    public int bottom() {
        return Math.max(this.y0, this.y1);
    }

    public void bottom(int n) {
        int n2 = n - this.bottom();
        this.y0 += n2;
        this.y1 += n2;
    }

    public Pt center() {
        return new Pt((this.x0 + this.x1) / 2, (this.y0 + this.y1) / 2);
    }

    public void center(Pt pt) {
        Pt pt2 = this.center();
        this.left(this.left() + (pt.x() - pt2.x()));
        this.top(this.top() + (pt.y() - pt2.y()));
    }

    public void clearOn(DrawingWindow drawingWindow) {
        drawingWindow.clearLine(this.x0, this.y0, this.x1, this.y1);
    }

    public Object clone() {
        return new Line(this);
    }

    public boolean contains(Pt pt) {
        if (this.height() == 0) {
            return pt.y() == this.top() && Line.within(pt.x(), this.left(), this.width());
        }
        if (this.width() == 0) {
            return pt.x() == this.left() && Line.within(pt.y(), this.top(), this.height());
        }
        if (!Line.within(pt.x(), this.left(), this.width())) {
            return false;
        }
        int n = (this.y1 - this.y0) * (pt.x() - this.x0) / (this.x1 - this.x0) + this.y0;
        return n == pt.y();
    }

    public void drawOn(DrawingWindow drawingWindow) {
        drawingWindow.drawLine(this.x0, this.y0, this.x1, this.y1);
    }

    public boolean equals(Object object) {
        Line line = (Line)object;
        return this.x0 == line.x0 && this.y0 == line.y0 && this.x1 == line.x1 && this.y1 == line.y1;
    }

    public void fillOn(DrawingWindow drawingWindow) {
        drawingWindow.fillLine(this.x0, this.y0, this.x1, this.y1);
    }

    public int hashCode() {
        return this.x0 + this.y0 + this.x1 + this.y1;
    }

    public int height() {
        return Math.abs(this.y0 - this.y1);
    }

    public Pt here() {
        return new Pt(this.x0, this.y0);
    }

    public int left() {
        return this.x0;
    }

    public void left(int n) {
        int n2 = n - this.left();
        this.x0 += n2;
        this.x1 += n2;
    }

    public int right() {
        return this.x1;
    }

    public void right(int n) {
        int n2 = n - this.right();
        this.x0 += n2;
        this.x1 += n2;
    }

    public Pt there() {
        return new Pt(this.x1, this.y1);
    }

    public String toString() {
        return "<Line: (" + this.x0 + "," + this.y0 + ") to (" + this.x1 + "," + this.y1 + ")>";
    }

    public int top() {
        return Math.min(this.y0, this.y1);
    }

    public void top(int n) {
        int n2 = n - this.top();
        this.y0 += n2;
        this.y1 += n2;
    }

    public int width() {
        return this.x1 - this.x0;
    }

    protected static boolean within(int n, int n2, int n3) {
        return n2 <= n && n <= n2 + n3;
    }
}

