/*
 * Decompiled with CFR 0.152.
 */
package element;

import element.Drawable;
import element.DrawingCanvas;
import element.Pt;
import element.Rect;
import element.Text;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;

public class DrawingWindow {
    private Container frame;
    private int width;
    private int height;
    private DrawingCanvas canvas;
    private Font font;
    private Graphics offscreen;
    protected static Graphics exampleContext;
    private Thread thread;
    private Color backColor;
    private Color foreColor;
    private Pt currentPosition;
    private int mode;
    private Color savedBackColor;
    private Color savedForeColor;
    private Pt savedCurrentPosition;
    private int savedMode;
    private static final int PAINT = 0;
    private static final int INVERT = 1;

    public DrawingWindow() {
        this(200, 200);
    }

    public DrawingWindow(int n, int n2) {
        this(n, n2, "Drawing Window");
    }

    public DrawingWindow(int n, int n2, Container container) {
        Thread.currentThread().setPriority(5);
        this.frame = container;
        this.canvas = new DrawingCanvas(n, n2);
        this.frame.add("Center", this.canvas);
        this.currentPosition = new Pt(0, 0);
        this.savedCurrentPosition = new Pt();
        this.width = n;
        this.height = n2;
        Thread.currentThread().setPriority(1);
        this.offscreen = this.canvas.getOffscreenGraphics();
        if (exampleContext == null) {
            exampleContext = this.offscreen;
        }
        this.font = new Font("Courier", 0, 12);
        this.offscreen.setFont(this.font);
        this.setForeground(Color.black);
        this.setBackground(Color.white);
        this.paintMode();
    }

    public DrawingWindow(int n, int n2, String string) {
        Thread.currentThread().setPriority(5);
        Frame frame = new Frame(string);
        this.frame = frame;
        this.canvas = new DrawingCanvas(n, n2);
        this.frame.add("Center", this.canvas);
        frame.pack();
        this.width = n;
        this.height = n2;
        this.currentPosition = new Pt(0, 0);
        this.savedCurrentPosition = new Pt();
        this.frame.setVisible(true);
        Thread.currentThread().setPriority(1);
        this.offscreen = this.canvas.getOffscreenGraphics();
        if (exampleContext == null) {
            exampleContext = this.offscreen;
        }
        this.font = new Font("Courier", 0, 12);
        this.offscreen.setFont(this.font);
        this.setForeground(Color.black);
        this.setBackground(Color.white);
        this.paintMode();
    }

    public DrawingWindow(Container container) {
        this(200, 200, container);
    }

    public char awaitKey() {
        return this.canvas.awaitKey();
    }

    public Pt awaitMouseClick() {
        this.canvas.awaitMousePress();
        return this.canvas.awaitMouseRelease();
    }

    public Pt awaitMousePress() {
        return this.canvas.awaitMousePress();
    }

    public Pt awaitMouseRelease() {
        return this.canvas.awaitMouseRelease();
    }

    public Rect bounds() {
        return new Rect(0, 0, this.width, this.height);
    }

    public void clear(Drawable drawable) {
        drawable.clearOn(this);
    }

    public void clearArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.save();
        this.paintMode();
        this.setForeground(this.backColor);
        this.fillArc(n, n2, n3, n4, n5, n6);
        this.canvas.repaint(n, n2, n + n3, n2 + n4);
        this.restore();
    }

    public void clearCircle(int n, int n2, int n3) {
        this.clearOval(n, n2, n3 * 2, n3 * 2);
    }

    public void clearLine(int n, int n2, int n3, int n4) {
        this.save();
        this.paintMode();
        this.setForeground(this.backColor);
        this.drawLine(n, n2, n3, n4);
        this.canvas.repaint(n, n2, n3, n4);
        this.restore();
    }

    public void clearLine(Pt pt, Pt pt2) {
        this.clearLine(pt.x(), pt.y(), pt2.x(), pt2.y());
    }

    public void clearOval(int n, int n2, int n3, int n4) {
        this.save();
        this.paintMode();
        this.setForeground(this.backColor);
        this.fillOval(n, n2, n3, n4);
        this.restore();
    }

    public void clearPt(int n, int n2) {
        this.clearLine(n, n2, n, n2);
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.offscreen.clearRect(n, n2, n3, n4);
        this.canvas.repaint(n, n2, n + n3, n + n4);
    }

    public void clearRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.save();
        this.paintMode();
        this.setForeground(this.backColor);
        this.fillRoundRect(n, n2, n3, n4, n5, n6);
        this.restore();
    }

    public void clearText(Text text) {
        this.save();
        this.setForeground(this.backColor);
        this.drawText(text);
        this.canvas.repaint(text.left(), text.top(), text.width(), text.height());
        this.restore();
    }

    public void draw(Drawable drawable) {
        drawable.drawOn(this);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.offscreen.drawArc(n, n2, n3, n4, n5, n6);
        this.canvas.repaint(n, n2, n + n3, n2 + n4);
    }

    public void drawCircle(int n, int n2, int n3) {
        this.drawOval(n, n2, n3 * 2, n3 * 2);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.offscreen.drawLine(n, n2, n3, n4);
        this.canvas.repaint(n, n2, n3, n4);
    }

    public void drawLine(Pt pt, Pt pt2) {
        this.drawLine(pt.x(), pt.y(), pt2.x(), pt2.y());
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.offscreen.drawOval(n, n2, n3, n4);
        this.canvas.repaint(n, n2, n + n3, n2 + n4);
    }

    public void drawPt(int n, int n2) {
        this.drawLine(n, n2, n, n2);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.offscreen.drawRect(n, n2, n3, n4);
        this.canvas.repaint(n, n2, n + n3, n2 + n4);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.offscreen.drawRoundRect(n, n2, n3, n4, n5, n6);
        this.canvas.repaint(n, n2, n + n3, n2 + n4);
    }

    public void drawString(String string, int n, int n2) {
        this.drawText(new Text(string, n, n2));
    }

    public void drawText(Text text) {
        this.offscreen.setFont(text.font());
        this.offscreen.drawString(text.string(), text.left(), text.bottom());
        this.canvas.repaint(text.left(), text.top(), text.width(), text.height());
    }

    public void fill(Drawable drawable) {
        drawable.fillOn(this);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.offscreen.fillArc(n, n2, n3, n4, n5, n6);
        this.canvas.repaint(n, n2, n + n3, n2 + n4);
    }

    public void fillCircle(int n, int n2, int n3) {
        this.fillOval(n, n2, n3 * 2, n3 * 2);
    }

    public void fillLine(int n, int n2, int n3, int n4) {
        this.drawLine(n, n2, n3, n4);
    }

    public void fillLine(Pt pt, Pt pt2) {
        this.drawLine(pt, pt2);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.offscreen.fillOval(n, n2, n3, n4);
        this.canvas.repaint(n, n2, n + n3, n2 + n4);
    }

    public void fillPt(int n, int n2) {
        this.fillLine(n, n2, n, n2);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.offscreen.fillRect(n, n2, n3, n4);
        this.canvas.repaint(n, n2, n + n3, n2 + n4);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.offscreen.fillRoundRect(n, n2, n3, n4, n5, n6);
        this.canvas.repaint(n, n2, n + n3, n2 + n4);
    }

    public void fillText(Text text) {
        this.drawText(text);
    }

    public Pt getMouse() {
        return this.canvas.getMouse();
    }

    public void grid() {
        this.grid(10, 10);
    }

    public void grid(int n, int n2) {
        this.hold();
        this.save();
        this.setForeground(Color.lightGray);
        int n3 = 0;
        while (n3 < this.width) {
            this.moveTo(n3, 0);
            this.line(0, this.height);
            n3 += n;
        }
        int n4 = 0;
        while (n4 < this.height) {
            this.moveTo(0, n4);
            this.line(this.width, 0);
            n4 += n2;
        }
        this.restore();
        this.release();
    }

    public void hold() {
        this.canvas.hold();
    }

    public void invertMode() {
        this.mode = 1;
        this.offscreen.setXORMode(this.backColor);
    }

    public void line(int n, int n2) {
        this.lineTo(this.currentPosition.x() + n, this.currentPosition.y() + n2);
    }

    public void lineTo(int n, int n2) {
        this.drawLine(this.currentPosition.x(), this.currentPosition.y(), n, n2);
        this.currentPosition.moveTo(n, n2);
    }

    public void lineTo(Pt pt) {
        this.lineTo(pt.x(), pt.y());
    }

    public boolean mousePressed() {
        return this.canvas.mousePressed();
    }

    public void move(int n, int n2) {
        this.currentPosition.move(n, n2);
    }

    public void moveTo(int n, int n2) {
        this.currentPosition.moveTo(n, n2);
    }

    public void moveTo(Pt pt) {
        this.currentPosition.moveTo(pt);
    }

    public void paintMode() {
        this.mode = 0;
        this.offscreen.setPaintMode();
    }

    public void release() {
        this.canvas.release();
    }

    private void restore() {
        if (this.foreColor != this.savedForeColor) {
            this.setForeground(this.savedForeColor);
        }
        if (this.backColor != this.savedBackColor) {
            this.setBackground(this.savedBackColor);
        }
        this.currentPosition = this.savedCurrentPosition;
        if (this.mode != this.savedMode) {
            if (this.savedMode == 0) {
                this.paintMode();
            } else {
                this.invertMode();
            }
        }
    }

    private void save() {
        this.savedForeColor = this.foreColor;
        this.savedBackColor = this.backColor;
        this.savedCurrentPosition = new Pt(this.currentPosition);
        this.savedMode = this.mode;
    }

    public void setBackground(Color color) {
        this.backColor = color;
        if (this.mode == 1) {
            this.invertMode();
        }
        this.canvas.setBackground(color);
    }

    public void setForeground(Color color) {
        this.offscreen.setColor(color);
        this.foreColor = color;
    }
}

