/*
 * Decompiled with CFR 0.152.
 */
package element;

import element.Barrier;
import element.Pt;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.ImageProducer;

class DrawingCanvas
extends Canvas
implements MouseListener,
MouseMotionListener,
KeyListener,
WindowListener {
    Pt mouse;
    boolean mousePressed;
    int buttonMask = 28;
    Image[] osi;
    Graphics[] osg;
    int cbi;
    int holdDepth;
    int width;
    int height;
    Barrier started;
    Barrier mousePressLock;
    Barrier mouseReleaseLock;
    Barrier keyLock;
    char keyChar;

    public DrawingCanvas() {
        this(200, 200);
    }

    public DrawingCanvas(int n, int n2) {
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.setSize(n, n2);
        this.width = n;
        this.height = n2;
        this.osi = null;
        this.osg = null;
        this.cbi = 0;
        this.holdDepth = 0;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.mouse = new Pt();
        this.started = new Barrier();
        this.mousePressLock = new Barrier();
        this.mouseReleaseLock = new Barrier();
        this.keyLock = new Barrier();
    }

    public char awaitKey() {
        this.keyLock.P();
        return this.keyChar;
    }

    public Pt awaitMousePress() {
        if (!this.mousePressed) {
            this.mousePressLock.P();
        }
        return this.getMouse();
    }

    public Pt awaitMouseRelease() {
        if (this.mousePressed) {
            this.mouseReleaseLock.P();
        }
        return this.getMouse();
    }

    public Image getImage(ImageProducer imageProducer) {
        if (this.osi == null) {
            this.started.P();
        }
        return this.createImage(imageProducer);
    }

    public Pt getMouse() {
        return new Pt(this.mouse);
    }

    public Graphics getOffscreenGraphics() {
        if (this.osi == null) {
            this.started.P();
        }
        return this.osg[0];
    }

    public void hold() {
        if (this.cbi != 1) {
            this.cbi = 1;
            this.osg[this.cbi].drawImage(this.osi[0], 0, 0, null);
        }
        ++this.holdDepth;
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.keyChar = keyEvent.getKeyChar();
        if (this.keyChar >= '\u0000' && this.keyChar <= '~') {
            this.keyLock.V();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.mouse.moveTo(mouseEvent.getX(), mouseEvent.getY());
        this.updateMouseR(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouse.moveTo(mouseEvent.getX(), mouseEvent.getY());
        this.updateMouseP(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouse.moveTo(mouseEvent.getX(), mouseEvent.getY());
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mouse.moveTo(mouseEvent.getX(), mouseEvent.getY());
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouse.moveTo(mouseEvent.getX(), mouseEvent.getY());
        this.updateMouseR(mouseEvent);
    }

    public boolean mousePressed() {
        return this.mousePressed;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouse.moveTo(mouseEvent.getX(), mouseEvent.getY());
        this.updateMouseP(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouse.moveTo(mouseEvent.getX(), mouseEvent.getY());
        this.updateMouseR(mouseEvent);
    }

    public void paint(Graphics graphics) {
        if (this.osi == null) {
            this.osi = new Image[2];
            this.osi[0] = this.createImage(this.width, this.height);
            this.osi[1] = this.createImage(this.width, this.height);
            this.osg = new Graphics[2];
            this.osg[0] = this.osi[0].getGraphics();
            this.osg[1] = this.osi[1].getGraphics();
            this.cbi = 0;
            this.started.V();
        }
        graphics.drawImage(this.osi[this.cbi], 0, 0, null);
    }

    public void release() {
        --this.holdDepth;
        if (this.holdDepth <= 0) {
            this.cbi = 0;
            this.repaint();
        }
    }

    public void repaint(int n, int n2, int n3, int n4) {
        if (this.cbi == 1) {
            return;
        }
        this.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private void updateMouse(MouseEvent mouseEvent) {
        boolean bl = this.mousePressed;
        boolean bl2 = this.mousePressed = (mouseEvent.getModifiers() & this.buttonMask) != 0;
        if (bl != this.mousePressed) {
            if (this.mousePressed) {
                this.mousePressLock.V();
            } else {
                this.mouseReleaseLock.V();
            }
        }
    }

    private void updateMouseP(MouseEvent mouseEvent) {
        boolean bl = this.mousePressed;
        this.mousePressed = true;
        if (bl != this.mousePressed) {
            this.mousePressLock.V();
        }
    }

    private void updateMouseR(MouseEvent mouseEvent) {
        boolean bl = this.mousePressed;
        this.mousePressed = false;
        if (bl != this.mousePressed) {
            this.mouseReleaseLock.V();
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
        System.out.println("windowActivated");
    }

    public void windowClosed(WindowEvent windowEvent) {
        System.out.println("windowClosed");
    }

    public void windowClosing(WindowEvent windowEvent) {
        System.out.println("windowClosing");
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        System.out.println("windowDeactivated");
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        System.out.println("windowDeiconified");
    }

    public void windowIconified(WindowEvent windowEvent) {
        System.out.println("windowIconified");
    }

    public void windowOpened(WindowEvent windowEvent) {
        System.out.println("windowOpened");
    }
}

