/*
 * Decompiled with CFR 0.152.
 */
package element;

import element.ConsoleCanvas;
import element.ConsoleKeyboard;
import element.ConsoleOutput;
import element.ConsoleScrollbar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.io.InputStream;
import java.io.PrintWriter;
import structure.ReadStream;

public class ConsoleWindow {
    Container theContainer;
    ConsoleCanvas area;
    ConsoleScrollbar rowScroller;
    ConsoleScrollbar colScroller;
    public PrintWriter out;
    public InputStream in;
    public ReadStream input;
    Thread mainThread;

    public ConsoleWindow() {
        this(24, 80, "Console Window");
    }

    public ConsoleWindow(int n, int n2, String string) {
        this(n, n2, string, new Font("Courier", 0, 10), null);
    }

    public ConsoleWindow(int n, int n2, String string, Font font, Container container) {
        if (System.getProperty("stdio") == null) {
            Frame frame = null;
            if (container == null) {
                frame = new Frame();
                frame.setTitle(string);
                frame.setResizable(true);
                container = frame;
            }
            this.mainThread = Thread.currentThread();
            container.setLayout(new BorderLayout());
            container.setBackground(Color.white);
            container.setForeground(Color.black);
            container.setFont(font);
            this.area = new ConsoleCanvas(n, n2, font);
            this.rowScroller = new ConsoleScrollbar(1, this.area);
            this.colScroller = new ConsoleScrollbar(0, this.area);
            this.area.setScrollbar(this.rowScroller, this.colScroller);
            this.out = new PrintWriter(new ConsoleOutput(this.area), true);
            this.in = new ConsoleKeyboard(this.area);
            this.input = new ReadStream(this.in);
            container.add("Center", this.area);
            container.add("East", this.rowScroller);
            container.add("South", this.colScroller);
            if (frame != null) {
                frame.pack();
                ((Component)frame).setVisible(true);
            }
            this.area.requestFocus();
            this.theContainer = container;
        } else {
            this.out = new PrintWriter(System.out, true);
            this.in = System.in;
            this.input = new ReadStream(this.in);
        }
    }

    public ConsoleWindow(Container container) {
        this(24, 80, "Console Window", new Font("Courier", 0, 10), container);
    }

    public String toString() {
        return "<Console Window>";
    }
}

