/*
 * Decompiled with CFR 0.152.
 */
package element;

import element.ConsoleCanvas;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

class ConsoleScrollbar
extends Scrollbar
implements AdjustmentListener {
    protected ConsoleCanvas theCanvas;
    protected int rows;
    protected int lineCount;
    protected int pageSize;
    protected int currentValue;

    ConsoleScrollbar(int n, ConsoleCanvas consoleCanvas) {
        super(n);
        this.theCanvas = consoleCanvas;
        this.pageSize = this.rows = n == 1 ? this.theCanvas.rows() : this.theCanvas.cols();
        this.lineCount = this.rows;
        this.addAdjustmentListener(this);
        this.setValues(0, this.pageSize, 0, this.lineCount);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.theCanvas.repaint();
    }

    synchronized void expandTo(int n) {
        int n2 = this.getValue();
        if (n > this.lineCount) {
            if (n2 >= this.lineCount - 1) {
                n2 = n - 1;
            }
            this.lineCount = n;
            this.setValues(n2, this.pageSize, 0, this.lineCount);
        }
        if (n <= n2 || n >= n2 + this.pageSize) {
            this.setValues(n - 1, this.pageSize, 0, this.lineCount);
        }
    }

    synchronized void scrollMaximum() {
        this.setValues(this.lineCount - 1, this.pageSize, 0, this.lineCount);
    }

    synchronized void scrollMinimum() {
        this.setValues(0, this.pageSize, 0, this.lineCount);
    }
}

