/*
 * Decompiled with CFR 0.152.
 */
package element;

import element.ConsoleCanvas;
import element.ConsoleException;
import element.ConsoleLine;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

class ConsoleKeyboard
extends PipedInputStream {
    PipedOutputStream outputPipe;
    ConsoleCanvas canvas;
    ConsoleLine lineBuffer;

    ConsoleKeyboard(ConsoleCanvas consoleCanvas) {
        this.canvas = consoleCanvas;
        try {
            this.outputPipe = new PipedOutputStream(this);
        }
        catch (IOException iOException) {}
        this.lineBuffer = new ConsoleLine(80);
        consoleCanvas.setKeyboard(this);
    }

    void doKeyHit(byte by) {
        if (this.outputPipe == null) {
            return;
        }
        if (by == 127) {
            by = (byte)8;
        }
        if (by == 13) {
            by = (byte)10;
        }
        if (by == 4) {
            try {
                this.outputPipe.close();
                this.outputPipe = null;
            }
            catch (IOException iOException) {
                throw new ConsoleException("Error terminating keyboard.");
            }
        }
        if (by == 10) {
            this.canvas.write(by);
            try {
                this.outputPipe.write(this.lineBuffer.data, 0, this.lineBuffer.length);
                this.outputPipe.write(by);
                this.outputPipe.flush();
            }
            catch (IOException iOException) {
                throw new ConsoleException("Error reading from keyboard");
            }
            this.lineBuffer.length = 0;
        } else if (by != 8 || this.lineBuffer.length != 0) {
            this.canvas.write(by);
            this.lineBuffer.append(by);
        }
    }
}

