/*
 * Decompiled with CFR 0.152.
 */
package element;

import element.ConsoleKeyboard;
import element.ConsoleLine;
import element.ConsoleScrollbar;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;

class ConsoleCanvas
extends Canvas
implements KeyListener {
    final int BORDER_WIDTH = 1;
    final int LEFT_MARGIN = 3;
    private int rows;
    private int cols;
    private Font theFont;
    private int charWidth;
    private int charHeight;
    private int charDown;
    private int charDescent;
    private int canvasWidth;
    private boolean paintDone;
    private Vector lines;
    private int maxWidth;
    ConsoleScrollbar rowScroller;
    ConsoleScrollbar colScroller;
    ConsoleKeyboard keyboard;
    Image osi;
    Graphics osg;

    private ConsoleCanvas() {
    }

    ConsoleCanvas(int n, int n2, Font font) {
        this.rows = n;
        this.cols = n2;
        this.theFont = font;
        this.maxWidth = 0;
        this.setFont(font);
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.addKeyListener(this);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        this.charWidth = fontMetrics.getMaxAdvance();
        if (this.charWidth == -1) {
            this.charWidth = fontMetrics.charWidth('M');
        }
        this.charWidth = fontMetrics.stringWidth("0123456789") / 10;
        this.charHeight = fontMetrics.getHeight();
        this.charDown = fontMetrics.getAscent() + fontMetrics.getLeading() + 1;
        this.charDescent = fontMetrics.getMaxDescent();
        this.canvasWidth = this.charWidth * n2 + 3 - 1;
        this.setSize(this.canvasWidth + 2, (n + 1) * this.charHeight + 2);
        this.lines = new Vector();
        this.lines.addElement(new ConsoleLine(n2));
    }

    protected void addNewBottomLine(Graphics graphics) {
        this.lines.addElement(new ConsoleLine(this.cols));
        this.rowScroller.expandTo(this.lines.size());
        this.rowScroller.scrollMaximum();
        this.colScroller.scrollMinimum();
        this.update(graphics);
    }

    void append(byte by) {
        if (by == 10 || by == 13) {
            this.lines.addElement(new ConsoleLine(this.cols));
            this.rowScroller.expandTo(this.lines.size());
        } else {
            ConsoleLine consoleLine = (ConsoleLine)this.lines.lastElement();
            consoleLine.append(by);
            this.colScroller.expandTo(consoleLine.length);
        }
        this.rowScroller.scrollMaximum();
        this.repaint();
    }

    public int cols() {
        return this.cols;
    }

    public void keyPressed(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c > '\u0000' && c < '\u0080') {
            this.keyboard.doKeyHit((byte)c);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void paint(Graphics graphics) {
        if (this.osi == null) {
            Dimension dimension = this.getSize();
            this.osi = this.createImage(dimension.width, dimension.height);
            this.osg = this.osi.getGraphics();
        }
        int n = this.rowScroller.getValue();
        int n2 = this.colScroller.getValue();
        int n3 = this.lines.size();
        this.paintDone = true;
        this.osg.clearRect(0, 0, this.canvasWidth + 2, this.rows * this.charHeight + 2);
        int n4 = 0;
        while (n4 < this.rows && n < n3) {
            this.paintLine(this.osg, (ConsoleLine)this.lines.elementAt(n), n2, n4);
            ++n;
            ++n4;
        }
        graphics.drawImage(this.osi, 0, 0, null);
    }

    protected void paintLine(Graphics graphics, ConsoleLine consoleLine, int n, int n2) {
        int n3 = consoleLine.length - n;
        if (n3 > 0) {
            graphics.drawBytes(consoleLine.data, n, n3, 3, this.charDown + n2 * this.charHeight);
        }
    }

    public int rows() {
        return this.rows;
    }

    void setKeyboard(ConsoleKeyboard consoleKeyboard) {
        this.keyboard = consoleKeyboard;
    }

    void setScrollbar(ConsoleScrollbar consoleScrollbar, ConsoleScrollbar consoleScrollbar2) {
        this.rowScroller = consoleScrollbar;
        this.colScroller = consoleScrollbar2;
    }

    public String toString() {
        String string = "<Console canvas: " + this.rows + " rows " + this.cols + " cols " + this.lines.size() + " lines on screen\n";
        int n = 0;
        while (n < this.lines.size()) {
            string = String.valueOf(string) + ((ConsoleLine)this.lines.elementAt(n)).toString() + '\n';
            ++n;
        }
        string = String.valueOf(string) + ">";
        return string;
    }

    public void update(Graphics graphics) {
        if (!this.paintDone) {
            return;
        }
        this.paint(graphics);
    }

    protected void wipeLine(Graphics graphics, ConsoleLine consoleLine, int n, int n2) {
        int n3 = consoleLine.length - n;
        if (n3 > 0) {
            graphics.clearRect(3 + n * this.charWidth, 1 + n2 * this.charHeight + this.charDescent, (consoleLine.length - n) * this.charWidth, this.charHeight);
        }
    }

    void write(byte by) {
        if (by == 10 || by == 13) {
            this.lines.addElement(new ConsoleLine(this.cols));
            this.rowScroller.expandTo(this.lines.size());
        } else {
            ConsoleLine consoleLine = (ConsoleLine)this.lines.lastElement();
            consoleLine.append(by);
            this.colScroller.expandTo(consoleLine.length);
        }
        this.rowScroller.scrollMaximum();
        this.repaint();
    }
}

