/*
 * Decompiled with CFR 0.152.
 */
package element;

import element.Drawable;
import element.DrawingWindow;
import element.Oval;
import element.Pt;

public class Circle
extends Oval {
    public Circle() {
        this(0, 0, 0);
    }

    public Circle(int n, int n2, int n3) {
        super(n - n3, n2 - n3, 2 * n3, 2 * n3);
    }

    public Circle(Drawable drawable) {
        this(drawable.center().x(), drawable.center().y(), Math.min(drawable.width(), drawable.height()) / 2);
    }

    public Circle(Pt pt, int n) {
        this(pt.x(), pt.y(), n);
    }

    public void clearOn(DrawingWindow drawingWindow) {
        drawingWindow.clearCircle(this.left, this.top, this.width / 2);
    }

    public Object clone() {
        return new Circle((Drawable)this);
    }

    public boolean contains(Pt pt) {
        int n;
        int n2 = this.left() + this.width() / 2;
        int n3 = this.top() + this.height() / 2;
        int n4 = pt.x() - n2;
        return n4 * n4 + (n = pt.y() - n3) * n <= this.width * this.width / 4;
    }

    public void drawOn(DrawingWindow drawingWindow) {
        drawingWindow.drawCircle(this.left, this.top, this.width / 2);
    }

    public boolean equals(Object object) {
        Circle circle = (Circle)object;
        return this.left == circle.left && this.top == circle.top && this.width == circle.width && this.height == circle.height;
    }

    public void fillOn(DrawingWindow drawingWindow) {
        drawingWindow.fillCircle(this.left, this.top, this.width / 2);
    }

    public int hashCode() {
        return this.left + this.top + this.width + this.height;
    }

    public int radius() {
        return this.width / 2;
    }

    public void radius(int n) {
        int n2 = 2 * n;
        this.width(n2);
        this.height(n2);
    }

    public String toString() {
        return "<Circle: left=" + this.left + " top=" + this.top + " width=" + this.width + " height=" + this.height + ">";
    }
}

