/*
 * Decompiled with CFR 0.152.
 */
package element;

import element.DrawingWindow;
import element.Oval;
import element.Pt;
import element.Rect;

public class Arc
extends Oval {
    protected int start;
    protected int angle;

    public Arc() {
        this(0, 0, 0, 0, 0, 360);
    }

    public Arc(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.start = 0;
        this.angle = 360;
    }

    public Arc(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4);
        if (this.angle < 0) {
            this.angle = -this.angle;
            this.start -= this.angle;
        }
        this.start = Arc.canonical(n5);
        this.angle = n6;
    }

    public Arc(Arc arc) {
        this(arc.left(), arc.top(), arc.width(), arc.height(), arc.start, arc.angle);
    }

    public Arc(Pt pt, Pt pt2) {
        super(pt, pt2);
        this.start = 0;
        this.angle = 360;
    }

    public Arc(Rect rect, int n, int n2) {
        this(rect.left(), rect.top(), rect.width(), rect.height(), n, n2);
    }

    public int angle() {
        return this.angle;
    }

    public void angle(int n) {
        this.angle = n;
    }

    protected static int canonical(int n) {
        return (360 + (n - 360 * (n / 360))) % 360;
    }

    public void clearOn(DrawingWindow drawingWindow) {
        drawingWindow.clearArc(this.left, this.top, this.width, this.height, this.start, this.angle);
    }

    public Object clone() {
        return new Arc(this);
    }

    public boolean contains(Pt pt) {
        if (!super.contains(pt)) {
            return false;
        }
        int n = this.left() + this.width() / 2;
        int n2 = this.top() + this.height() / 2;
        int n3 = pt.x() - n;
        int n4 = n2 - pt.y();
        double d = Math.atan2(n4, n3);
        int n5 = Arc.canonical((int)(d * 180.0 / Math.PI));
        return Arc.canonical(n5 - this.start) <= this.angle;
    }

    public void drawOn(DrawingWindow drawingWindow) {
        drawingWindow.drawArc(this.left, this.top, this.width, this.height, this.start, this.angle);
    }

    public boolean equals(Object object) {
        Arc arc = (Arc)object;
        return this.left == arc.left && this.top == arc.top && this.width == arc.width && this.height == arc.height && this.start == arc.start && this.angle == arc.angle;
    }

    public void fillOn(DrawingWindow drawingWindow) {
        drawingWindow.fillArc(this.left, this.top, this.width, this.height, this.start, this.angle);
    }

    public int hashCode() {
        return this.left + this.top + this.width + this.height + this.start + this.angle;
    }

    public int start() {
        return this.start;
    }

    public void start(int n) {
        this.start = Arc.canonical(n);
    }

    public String toString() {
        return "<Arc: left=" + this.left + " top=" + this.top + " width=" + this.width + " height=" + this.height + " start=" + this.start + " angle=" + this.angle + ">";
    }
}

